﻿// ================================================================================================
// Copyright (c) 2012 All Rights Reserved
// Licensed Materials - Property of Zero One
// 
// (c) Copyright Zero One SAS - 2025
// ================================================================================================

using UnityEngine;

public class ShakeMe : MonoBehaviour
{
    public float Size = 20.0f;
    public float Speed = 10.0f;

    public Vector3 Axe = Vector3.forward;

    // --------------------------------------------------------------------------------------------
    protected void FixedUpdate()
    {
        float ratio = Mathf.Sin(Time.time * Speed) * 0.5f * Size;

        transform.localRotation = Quaternion.Euler(Axe * ratio);
    }

    // --------------------------------------------------------------------------------------------
}